package gov.va.vamf.scheduling.varutility.security;

import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.security.AppUser;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

import java.util.Collection;

public class MdwsKeysVoter<S> implements AccessDecisionVoter<S> {
	private final String MDWS_KEYS = "MDWS_KEYS";
    private String mdwsKeysAuthorized = "SD SUPERVISOR";

	@Override
	public boolean supports(ConfigAttribute attribute) {
        return MDWS_KEYS.equals(attribute.getAttribute());
	}

	@Override
	public boolean supports(Class<?> clazz) {
		return true;
	}

	@Override
	public int vote(Authentication authentication, S s, Collection<ConfigAttribute> attributes) {

        for (ConfigAttribute attribute : attributes) {
            if (supports(attribute)) {
                String[] mdwsKeysList = mdwsKeysAuthorized.split(",");

                for(String mdwsKey : mdwsKeysList) {
                    if (hasKey(authentication, mdwsKey.trim())) {
                        return AccessDecisionVoter.ACCESS_GRANTED;
                    }
                }
                return AccessDecisionVoter.ACCESS_DENIED;
            }
        }
        return AccessDecisionVoter.ACCESS_ABSTAIN;
	}

    private boolean hasKey(Authentication authentication, String key) {
        AppUser principal = (AppUser) authentication.getPrincipal();
        MdwsKeys mdwsKeys = principal.getMhpUser().getMdwsInfo().getKeys();
        int numKeys =  mdwsKeys.size();

        for(int i=0; i < numKeys; i++) {
            String name = mdwsKeys.get(i).getName();
            if(name.equals(key)) {
                return true;
            }
        }
        return false;
    }

    public String getMdwsKeysAuthorized() {
        return mdwsKeysAuthorized;
    }

    public void setMdwsKeysAuthorized(String mdwsKeysAuthorized) {
        this.mdwsKeysAuthorized = mdwsKeysAuthorized;
    }
}
